#include <iot_quickstart.h>

int1 g_MyHttpSending = FALSE;

/* The CCS HTTP Client library is very flexible in the manners of which
data can be sent to the remote HTTP server an how to read response
data from the remote HTTP server. See the ccs_http_client.h file for
a full documentation of this API. */
void MyHttpSend(void)
{
   // there are also non-ROM versions of these functions if you want to
   // dynamically control the parameters.
   HttpClientSetHostNameROM((rom char*)"<Product ID>.devmode-m2.exosite.io");
   HttpClientSetUrlROM((rom char*)"/onep:v1/stack/alias");
   HttpClientSetHostPort(80);
   HttpClientSetCustomHeadersROM((rom char*)"Content-Type: application/x-www-form-urlencoded; charset=utf-8\r\nX-Exosite-CIK: <Token>");
   static char cgi[64];
   cgi[0] = 0;
   int8 temp;
   int8 humid;
   dht11_read(&humid, &temp);
   char str[10];
   sprintf(str, "%u", temp);
   HttpClientAppendCgi(cgi, "Temperature", str,sizeof(cgi));
   sprintf(str, "%u", humid);
   HttpClientAppendCgi(cgi, "Humidity", str,sizeof(cgi));
   HttpClientSetCgiPost(cgi);

   HttpClientStart();
}

void StackPrintfChanges(void)
{
   static enum {PRINT_INIT=0, PRINT_NO_MAC, PRINT_NO_DHCP, PRINT_IDLE} state=0;

   switch(state)
   {
      case PRINT_INIT:
         printf("\n\rNo MAC Link: %X:%X:%X:%X:%X:%X", MY_MAC_BYTE1, MY_MAC_BYTE2, MY_MAC_BYTE3, MY_MAC_BYTE4, MY_MAC_BYTE5, MY_MAC_BYTE6);
         state = PRINT_NO_MAC;
         break;

      case PRINT_NO_MAC:
         if (MACIsLinked())
         {
           #if defined(STACK_USE_DHCP_CLIENT)
            if (!DHCPIsEnabled(0))
           #else
            if (0)
           #endif
            {
               printf("\n\rDHCP Disabled: %u.%u.%u.%u", MY_IP_BYTE1, MY_IP_BYTE2, MY_IP_BYTE3, MY_IP_BYTE4);
               state = PRINT_IDLE;
            }
            else
            {
               printf("\n\rDHCP Not Bound");
               state = PRINT_NO_DHCP;
            }
         }
         break;

     #if defined(STACK_USE_DHCP_CLIENT)
      case PRINT_NO_DHCP:
         if (!MACIsLinked())
         {
            state = PRINT_INIT;
            break;
         }
         if (DHCPIsBound(0))
         {
            state = PRINT_IDLE;
            printf("\n\rDHCP Bound: %u.%u.%u.%u", MY_IP_BYTE1, MY_IP_BYTE2, MY_IP_BYTE3, MY_IP_BYTE4);
         }
         break;
     #endif

      case PRINT_IDLE:
         if (
               !MACIsLinked()
              #if defined(STACK_USE_DHCP_CLIENT)
               || (DHCPIsEnabled(0) && !DHCPIsBound(0))
              #endif
            )
         {
            state = PRINT_INIT;
         }
         break;
   }
}

void IPAddressInit(void)
{
   AppConfig.Flags.bIsDHCPEnabled = TRUE;
   DHCPEnable(0); //enable nicWide stack support.

   //MAC address of this unit
   MY_MAC_BYTE1=MY_DEFAULT_MAC_BYTE1;
   MY_MAC_BYTE2=MY_DEFAULT_MAC_BYTE2;
   MY_MAC_BYTE3=MY_DEFAULT_MAC_BYTE3;
   MY_MAC_BYTE4=MY_DEFAULT_MAC_BYTE4;
   MY_MAC_BYTE5=MY_DEFAULT_MAC_BYTE5;
   MY_MAC_BYTE6=MY_DEFAULT_MAC_BYTE6;
}

void main()
{

   IPAddressInit();
   TickInit();
   enable_interrupts(GLOBAL);
   StackInit();


   while(TRUE)
   {

      // TCP/IP code
      StackTask();

      StackPrintfChanges();

      StackApplications();

      if (DHCPIsBound(0) && !g_MyHttpSending)    // todo: specify action condition, like a button press
      {
         printf("sending: ");
         g_MyHttpSending = TRUE;
         MyHttpSend();
      }
      else if (!HttpClientIsBusy() && g_MyHttpSending)
      {
         g_MyHttpSending = FALSE;
         delay_ms(5000); //Modify to change time between requests
         printf("%Lu\r\n", HttpClientGetResult()); 
         // todo: if you want to see the pass/fail of the request,
         //       use HttpClientGetResult()

         // TODO: if you want to see the file returned from the server,
         // the methods for doing this depend on if you called
         // HttpClientSetResponseBuffer(). See the documentation
         // in ccs_http_client.h for more information.
      }



      //TODO: User Code
   }

}
