#include <18F4620.h>
#device ADC=10

#fuses NOWDT


/*
TCP/IP Stack enabled.
Many TCP/IP configuration settings (servers enabled, ports used,
etc) are defined in TCPIPConfig.h.
Many hardware configuration settings (SPI port and GPIO pins used)
are defined in HardwareProfile.h.
*/

#include "tcpip/p18cxxx.h"
#use delay(clock=40MHz,crystal=10MHz)
#use rs232(baud=9600,parity=N,xmit=PIN_C6,rcv=PIN_C7,bits=8,stream=PORT1)


#define MIN(a,b)  ((a > b) ? b : a)

#include <stdint.h>
#include "tcpip/StackTsk2.h"
#include "tcpip/TCPIPConfig.h"
#include "tcpip/HardwareProfile.h"

typedef struct
{
   BYTE vSocketPurpose;
   BYTE vMemoryMedium;
   WORD wTXBufferSize;
   WORD wRXBufferSize;
} TCPSocketInitializer_t;

#if TCP_CONFIGURATION > 0
   TCPSocketInitializer_t TCPSocketInitializer[TCP_CONFIGURATION] =
   {
      #if defined(STACK_USE_CCS_HTTP2_SERVER)
         {TCP_PURPOSE_HTTP_SERVER, TCP_ETH_RAM, STACK_CCS_HTTP2_SERVER_TX_SIZE, STACK_CCS_HTTP2_SERVER_RX_SIZE},
      #endif
      #if defined(STACK_USE_SMTP_CLIENT)
         {TCP_PURPOSE_DEFAULT, TCP_ETH_RAM, STACK_CCS_SMTP_TX_SIZE, STACK_CCS_SMTP_RX_SIZE},
      #endif
      #if defined(STACK_USE_MY_TELNET_SERVER)
         {TCP_PURPOSE_TELNET, TCP_ETH_RAM, STACK_MY_TELNET_SERVER_TX_SIZE, STACK_MY_TELNET_SERVER_RX_SIZE},
      #endif
      #if defined(STACK_USE_CCS_HTTP_CLIENT)
         {TCP_PURPOSE_GENERIC_TCP_CLIENT, TCP_ETH_RAM, STACK_MY_HTTPC_TX_SIZE, STACK_MY_HTTPC_RX_SIZE},
      #endif
   };
#else
   #undef TCP_CONFIGURATION
   #define TCP_CONFIGURATION 1
   TCPSocketInitializer_t TCPSocketInitializer[TCP_CONFIGURATION] =
   {
      {TCP_PURPOSE_DEFAULT, TCP_ETH_RAM, 250, 250}
   };
#endif

#include "tcpip/StackTsk2.c"


//Character string from endpoint url
#define EXO_PRODUCT_ID <Your Product ID>

/* Optional */
//Number used in device ID
//#define EXO_DEV_ID_NUM 5

//Include the exosite request library
#include "exosite_http.c"

//Set the pin the DHT11 sensor's data pin is connected to_char_type
//Include the DHT11 library
#define PIN_DHT11_DATA PIN_B0
#include <dht11.c>

//Define the number of bytes allocated to storage strings for the http client
#define HOSTNAME_MAX 50
#define RESPONSE_MAX 250
#define HEADERS_MAX 150
#define URL_MAX 50
#define CGI_MAX 150

//Amount of time system waits between sending updates to exosite
#define MIN_WAIT_TIME 5 //in seconds
